// mst.java
// demonstracja minimalnego drzewa rozpinajcego
// aby uruchomi program: C:>java MSTApp (wersja angielska)
// aby skompilowa wersj polsk: C:>javac mst.java
// po kompilacji:         C:>java MSTApp
////////////////////////////////////////////////////////////////
class StackX
   {
   private final int SIZE = 20;
   private int[] st;
   private int top;
// -------------------------------------------------------------
   public StackX()           // konstruktor
      {
      st = new int[SIZE];    // utwrz tablic
      top = -1;
      }
// -------------------------------------------------------------
   public void push(int j)   // zapisz element na stosie
      { st[++top] = j; }
// -------------------------------------------------------------
   public int pop()          // pobierz element ze stosu
      { return st[top--]; }
// -------------------------------------------------------------
   public int peek()         // pobierz warto elementu na szczycie stosu
      { return st[top]; }
// -------------------------------------------------------------
   public boolean isEmpty()  // 'prawda', jeeli stos jest pusty
      { return (top == -1); }
// -------------------------------------------------------------
   }  // end class StackX
////////////////////////////////////////////////////////////////
class Vertex
   {
   public char label;        // etykieta (np. 'A')
   public boolean wasVisited;
// -------------------------------------------------------------
   public Vertex(char lab)   // konstruktor
      {
      label = lab;
      wasVisited = false;
      }
// -------------------------------------------------------------
   }  // end class Vertex
////////////////////////////////////////////////////////////////
class Graph
   {
   private final int MAX_VERTS = 20;
   private Vertex vertexList[]; // lista wierzchokw
   private int adjMat[][];      // matryca przylegania
   private int nVerts;          // bieca liczba wierzchokw
   private StackX theStack;
// ------------------------------------------------------------
   public Graph()               // konstruktor
      {
      vertexList = new Vertex[MAX_VERTS];
                                          // matryca przylegania
      adjMat = new int[MAX_VERTS][MAX_VERTS];
      nVerts = 0;
      for(int j=0; j<MAX_VERTS; j++)      // zerowanie matrycy
         for(int k=0; k<MAX_VERTS; k++)   //    przylegania
            adjMat[j][k] = 0;
      theStack = new StackX();
      }  // end constructor
// -------------------------------------------------------------
   public void addVertex(char lab)
      {
      vertexList[nVerts++] = new Vertex(lab);
      }
// -------------------------------------------------------------
   public void addEdge(int start, int end)
      {
      adjMat[start][end] = 1;
      adjMat[end][start] = 1;
      }
// -------------------------------------------------------------
   public void displayVertex(int v)
      {
      System.out.print(vertexList[v].label);
      }
// -------------------------------------------------------------
   public void mst()  // minimalne drzewo rozpinajce (przeszukiwanie "wgb"))
      {                                  // rozpocznij od wierzchoka 0
      vertexList[0].wasVisited = true;   // oznacz wierzchoek
      theStack.push(0);                  // zapisz na stos

      while( !theStack.isEmpty() )       // do oprnienia stosu
         {                               // pobierz szczytowy element stosu
         int currentVertex = theStack.peek();
         // pobierz nieodwiedzonego ssiada
         int v = getAdjUnvisitedVertex(currentVertex);
         if(v == -1)                     // jeeli nie ma wicej ssiadw
            theStack.pop();              //    zdejmij ze stosu
         else                            // jest ssiad
            {
            vertexList[v].wasVisited = true;  // oznacz
            theStack.push(v);                 // zapisz na stos
                                         // wywietl krawd
            displayVertex(currentVertex);     // od currentVertex
            displayVertex(v);                 // do v
            System.out.print(" ");
            }
         }  // end while(stos nie jest pusty)

         // stos pusty, procedura zakoczona
         for(int j=0; j<nVerts; j++)          // zerowanie znacznikw
            vertexList[j].wasVisited = false;
      }  // end mst()
// -------------------------------------------------------------
   // zwraca nie odwiedzony wierzchoek przylegy do v
   public int getAdjUnvisitedVertex(int v)
      {
      for(int j=0; j<nVerts; j++)
         if(adjMat[v][j]==1 && vertexList[j].wasVisited==false)
            return j;
      return -1;
      }  // end getAdjUnvisitedVert()
// -------------------------------------------------------------
   }  // end class Graph
////////////////////////////////////////////////////////////////
class MSTApp
   {
   public static void main(String[] args)
      {
      Graph theGraph = new Graph();
      theGraph.addVertex('A');    // 0  (pocztek drzewa MST)
      theGraph.addVertex('B');    // 1
      theGraph.addVertex('C');    // 2
      theGraph.addVertex('D');    // 3
      theGraph.addVertex('E');    // 4

      theGraph.addEdge(0, 1);     // AB
      theGraph.addEdge(0, 2);     // AC
      theGraph.addEdge(0, 3);     // AD
      theGraph.addEdge(0, 4);     // AE
      theGraph.addEdge(1, 2);     // BC
      theGraph.addEdge(1, 3);     // BD
      theGraph.addEdge(1, 4);     // BE
      theGraph.addEdge(2, 3);     // CD
      theGraph.addEdge(2, 4);     // CE
      theGraph.addEdge(3, 4);     // DE

      System.out.print("Minimalne drzewo rozpinajce: ");
      theGraph.mst();             // minimalne drzewo rozpinajce
      System.out.println();
      }  // end main()
   }  // end class MSTApp
////////////////////////////////////////////////////////////////

